/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTextField;

public class VWTaskIPAddressPanel
extends VWTaskTabPanel {
    private JTextField m_ipAddress = null;

    public VWTaskIPAddressPanel(String ipAddress) {
        this.setDoubleBuffered(true);
        this.setLayout(new GridBagLayout());
        this.initLayout();
        this.setIPAddress(ipAddress);
    }

    public void setIPAddress(String ipAddress) {
        this.m_ipAddress.setText(ipAddress);
    }

    public String getIPAddress() {
        return this.m_ipAddress.getText().trim();
    }

    public void setEditable(boolean editable) {
        this.m_ipAddress.setEditable(editable);
    }

    public void validateTextFields() throws VWException {
        boolean valid = false;
        String ip = this.getIPAddress();
        try {
            if (ip.equals("")) {
                throw new VWException("vw.apps.taskman.VWTaskIPAddressPanel.InvalidIPAddress", "The IP Address has not been specified.");
            }
            if (ip.startsWith(".") || ip.endsWith(".")) {
                throw new Exception();
            }
            String[] tokens = ip.split("\\.");
            if (tokens.length != 4 && tokens.length != 6) {
                throw new Exception();
            }
            for (int i = 0; i < tokens.length; ++i) {
                Integer.parseInt(tokens[i]);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Invalid IP address: " + ip);
            throw new VWException("vw.apps.taskman.VWTaskIPAddressPanel.InvalidIPAddress", "Invalid IP address: {0}", ip);
        }
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 23;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.m_ipAddress = new JTextField();
        this.add((Component)this.m_ipAddress, c);
    }
}

